<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInterviewAttemptsTable extends Migration
{
    public function up()
    {
        // Ensure referenced tables exist before creating this table
        Schema::create('interview_attempts', function (Blueprint $table) {
            $table->id('Name_id'); // Primary key
            $table->unsignedBigInteger('Type')->nullable(); // Changed to unsignedBigInteger for consistency
            $table->string('Collation')->nullable();
            $table->string('Attributes')->nullable();
            $table->enum('Null', ['YES', 'NO'])->nullable();
            $table->text('Comments')->nullable();
            $table->string('Extra')->nullable();
            $table->string('Action')->nullable();
            $table->unsignedBigInteger('Application_id')->nullable()->index();
            $table->unsignedBigInteger('Job_id')->nullable()->index();
            $table->unsignedBigInteger('Interviewer_id')->nullable()->index();
            $table->unsignedBigInteger('User_id')->nullable()->index();
            $table->dateTime('Scheduled_at')->nullable();
            $table->string('Integration_id', 100)->nullable();
            $table->enum('Status', ['scheduled', 'completed', 'cancelled'])->nullable();
            $table->boolean('Is_completed')->nullable();
            $table->string('Video_link', 255)->nullable();
            $table->integer('Duration_minutes')->nullable(); // Renamed from 'duration' for clarity
            $table->enum('Interview_type', ['technical', 'hr', 'managerial'])->nullable();
            $table->unsignedBigInteger('Interviewee_id')->nullable()->index();
            $table->unsignedBigInteger('Interview_id')->nullable()->index();
            $table->text('Feedback_at')->nullable();
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

            // Foreign key constraints
            $table->foreign('Application_id')
                  ->references('Application_id')
                  ->on('job_applications')
                  ->onDelete('set null');
            $table->foreign('Interviewer_id')
                  ->references('User_id')
                  ->on('users')
                  ->onDelete('set null');
            $table->foreign('Job_id')
                  ->references('Job_id')
                  ->on('jobs')
                  ->onDelete('cascade');
            $table->foreign('User_id')
                  ->references('User_id')
                  ->on('users')
                  ->onDelete('cascade');
            $table->foreign('Interview_id')
                  ->references('Interview_id')
                  ->on('interviews')
                  ->onDelete('set null');
            $table->foreign('Interviewee_id')
                  ->references('User_id')
                  ->on('users')
                  ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('interview_attempts');
    }
}
